/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.impl.IPCResponseFactory;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.DHCPOptions;
import com.cisco.pt.ipc.sim.pdu.impl.PduImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHCPOptionsImpl
extends PduImpl
implements DHCPOptions {
    protected boolean isSubOption;
    protected int optionCode;
    protected int length;
    protected List<String> listOptions;
    protected List<DHCPOptions> listSubOptoins;
    protected DHCPOptions parentOption;

    public DHCPOptionsImpl() {
        this.fieldNames.add("DHCPOptionsImpl_isSubOption");
        this.fieldNames.add("DHCPOptionsImpl_optionCode");
        this.fieldNames.add("DHCPOptionsImpl_length");
        this.fieldNames.add("DHCPOptionsImpl_listOptions");
        this.fieldNames.add("DHCPOptionsImpl_listSubOptoins");
        this.fieldNames.add("DHCPOptionsImpl_parentOption");
        this.signalType = "DhcpOptions";
    }

    @Override
    public boolean getIsSubOption() {
        return this.isSubOption;
    }

    @Override
    public void setIsSubOption(boolean isSubOption) {
        this.isSubOption = isSubOption;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPOptionsImpl_isSubOption")) continue;
            this.fieldTable.set(i, new Pair<String, Boolean>("DHCPOptionsImpl_isSubOption", isSubOption));
            return;
        }
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public void setOptionCode(int optionCode) {
        this.optionCode = optionCode;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPOptionsImpl_optionCode")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("DHCPOptionsImpl_optionCode", optionCode));
            return;
        }
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPOptionsImpl_length")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("DHCPOptionsImpl_length", length));
            return;
        }
    }

    @Override
    public List<String> getListOptions() {
        return this.listOptions;
    }

    @Override
    public void setListOptions(List<String> listOptions) {
        this.listOptions = listOptions;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPOptionsImpl_listOptions")) continue;
            this.fieldTable.set(i, new Pair<String, List<String>>("DHCPOptionsImpl_listOptions", listOptions));
            return;
        }
    }

    @Override
    public List<DHCPOptions> getListSubOptoins() {
        return this.listSubOptoins;
    }

    @Override
    public void setListSubOptoins(List<DHCPOptions> listSubOptoins) {
        this.listSubOptoins = listSubOptoins;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPOptionsImpl_listSubOptoins")) continue;
            this.fieldTable.set(i, new Pair<String, List<DHCPOptions>>("DHCPOptionsImpl_listSubOptoins", listSubOptoins));
            return;
        }
    }

    @Override
    public DHCPOptions getParentOption() {
        return this.parentOption;
    }

    @Override
    public void setParentOption(DHCPOptions parentOption) {
        this.parentOption = parentOption;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPOptionsImpl_parentOption")) continue;
            this.fieldTable.set(i, new Pair<String, DHCPOptions>("DHCPOptionsImpl_parentOption", parentOption));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("DHCPOptionsImpl_isSubOption")) {
            return PtmpTypeValue.BOOL;
        }
        if (fieldName.equals("DHCPOptionsImpl_optionCode")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("DHCPOptionsImpl_length")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("DHCPOptionsImpl_listOptions")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("DHCPOptionsImpl_listSubOptoins")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("DHCPOptionsImpl_parentOption")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, Boolean>("DHCPOptionsImpl_isSubOption", this.isSubOption));
        this.fieldTable.add(new Pair<String, Integer>("DHCPOptionsImpl_optionCode", this.optionCode));
        this.fieldTable.add(new Pair<String, Integer>("DHCPOptionsImpl_length", this.length));
        this.fieldTable.add(new Pair<String, List<String>>("DHCPOptionsImpl_listOptions", this.listOptions));
        this.fieldTable.add(new Pair<String, List<DHCPOptions>>("DHCPOptionsImpl_listSubOptoins", this.listSubOptoins));
        this.fieldTable.add(new Pair<String, DHCPOptions>("DHCPOptionsImpl_parentOption", this.parentOption));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.isSubOption = this.readBoolean(buffer);
        this.optionCode = this.readInt(buffer);
        this.length = this.readInt(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.listOptions = new ArrayList<String>();
        for (Object o : tempList1) {
            this.listOptions.add((String)o);
        }
        List<Object> tempList2 = this.readVector(buffer);
        this.listSubOptoins = new ArrayList<DHCPOptions>();
        for (Object o : tempList2) {
            this.listSubOptoins.add((DHCPOptions)o);
        }
        this.parentOption = (DHCPOptions)this.readIPCData(buffer);
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.isSubOption = this.pduReadBoolean(buffer);
        this.optionCode = this.pduReadInt(buffer);
        this.length = this.pduReadInt(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)8);
        this.listOptions = new ArrayList<String>();
        for (Object o : tempList1) {
            this.listOptions.add((String)o);
        }
        List<Object> tempList2 = this.pduReadVector(buffer, (byte)16);
        this.listSubOptoins = new ArrayList<DHCPOptions>();
        for (Object o : tempList2) {
            this.listSubOptoins.add((DHCPOptions)o);
        }
        this.parentOption = (DHCPOptions)IPCResponseFactory.getPDUData(buffer);
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putBool(this.isSubOption);
        buffer.putInt(this.optionCode);
        buffer.putInt(this.length);
        buffer.putInt(this.listOptions.size());
        for (String string : this.listOptions) {
            buffer.putString(string);
        }
        buffer.putInt(this.listSubOptoins.size());
        for (DHCPOptions dHCPOptions : this.listSubOptoins) {
            dHCPOptions.encodeTypeAndPayload(buffer);
        }
        if (this.parentOption == null) {
            buffer.putString("");
        } else {
            this.parentOption.encodeTypeAndPayload(buffer);
        }
    }
}

